<?php
require_once 'parser.php';
require_once "config.php";

// CORS başlıklarını ekle
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST');
header('Access-Control-Allow-Headers: Content-Type');

// M3U dosyasını okuma fonksiyonu
function getM3UContent($url) {
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
    curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36');
    
    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);

    if ($httpCode == 200) {
        return $response;
    }
    return false;
}

// M3U içeriğini al
$playlistContent = "";
if (isset($_POST['iptv'])) {
    $m3uContent = getM3UContent($_POST['iptv']);
    if ($m3uContent !== false) {
        $playlistContent = $m3uContent;
    }
}
?>
<!DOCTYPE html>
<html lang="en">
   <head>
      <meta charset="utf-8">
      <meta http-equiv="X-UA-Compatible" content="IE=edge">
      <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
      <meta name="description" content="NodeTent">
      <meta name="author" content="NodeTent">
      <title><?=$title?></title>
      <!-- Favicon Icon -->
      <link rel="icon" type="image/png" href="<?=$favicon?>">
      <!-- Bootstrap core CSS-->
      <link href="vendor/bootstrap/css/bootstrap.min.css" rel="stylesheet">
      <!-- Custom fonts for this template-->
      <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
      <!-- Custom styles for this template-->
      <link href="css/style.css" rel="stylesheet">
      <!-- Owl Carousel -->
      <link rel="stylesheet" href="vendor/owl-carousel/owl.carousel.css">
      <link rel="stylesheet" href="vendor/owl-carousel/owl.theme.css">
        <script type="text/javascript" src="https://cdn.jsdelivr.net/npm/clappr@latest/dist/clappr.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/clappr.chromecast-plugin/latest/clappr-chromecast-plugin.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/gh/clappr/clappr-level-selector-plugin@latest/dist/level-selector.min.js"></script>
        <script type="text/javascript" src="https://cdn.jsdelivr.net/gh/mokoshalb/clappr-ads/ads.js"></script>
       <script type="text/javascript" src="js/player-error.js"></script>
       <link href="css/custom.css" rel="stylesheet">
       <link href="https://fonts.googleapis.com/css2?family=Roboto:wght@400;500;700&display=swap" rel="stylesheet">
   </head>
   <body id="page-top" class="bg-dark">
      <a href="https://arenasports.com" target="_blank" rel="nofollow noopener" id="clickable-background"></a>
      <div id="overlay"></div>
      <div class="mobile-menu">
          <button class="close-menu">
              <i class="fas fa-bars"></i>
          </button>
          <ul>
              <li><a href="#"><i class="fas fa-home"></i>Ana Sayfa</a></li>
              <li><a href="#"><i class="fas fa-video"></i>Canlı Maç İzle</a></li>
              <li><a href="#"><i class="fas fa-tv"></i>Taraftarium24</a></li>
              <li><a href="#"><i class="fas fa-play-circle"></i>Justin Tv</a></li>
              <li><a href="#"><i class="fas fa-check-circle"></i>Güvenilir Siteler</a></li>
          </ul>
      </div>
      <div class="site-content">
         <header class="site-header">
            <div class="container-fluid">
               <nav class="navbar navbar-expand-lg">
                  <a class="navbar-brand" href="#"><img src="<?=$navLogo?>" height="<?=$navLogoHeight?>" alt="<?=$navLogoAlt?>"></a>
                  <button class="menu-toggle">
                     <i class="fas fa-bars"></i>
                  </button>
                  <div class="collapse navbar-collapse">
                     <ul class="navbar-nav mr-auto">
                        <li class="nav-item"><a class="nav-link" href="#"><i class="fas fa-home"></i>Ana Sayfa</a></li>
                        <li class="nav-item"><a class="nav-link" href="#"><i class="fas fa-video"></i>Canlı Maç İzle</a></li>
                        <li class="nav-item"><a class="nav-link" href="#"><i class="fas fa-tv"></i>Taraftarium24</a></li>
                        <li class="nav-item"><a class="nav-link" href="#"><i class="fas fa-play-circle"></i>Justin Tv</a></li>
                        <li class="nav-item"><a class="nav-link" href="#"><i class="fas fa-check-circle"></i>Güvenilir Siteler</a></li>
                     </ul>
                  </div>
               </nav>
            </div>
         </header>

         <div class="main-container">
            <div class="content-wrapper">
               <!-- Üst banner'lar -->
               <div class="banner-container top-banners">
                  <div class="row">
                     <?php foreach($banners['top'] as $banner): ?>
                        <div class="col-md-4 col-sm-12">
                           <div class="reklam-banner">
                              <a href="<?=$banner['link']?>" target="_blank" rel="nofollow noopener">
                                 <img src="<?=$banner['image']?>" alt="<?=$banner['alt']?>">
                              </a>
                           </div>
                        </div>
                     <?php endforeach; ?>
                  </div>
               </div>

               <div class="container-fluid">
                  <div class="row">
                     <!-- Sol Sidebar - Kanal Listesi -->
                     <div class="col-md-2">
                        <div class="kanal-listesi">
                           <h3 class="baslik">KANALLAR</h3>
                           <div style="position: relative;">
                              <i class="fas fa-search kanal-arama-icon"></i>
                              <input type="text" class="kanal-arama" placeholder="Kanal ara...">
                           </div>
                           <ul class="nav flex-column">
                              <?php foreach ($items as $item) { ?>
                                 <li class="nav-item">
                                    <a class="channel nav-link" data-value="<?php echo $item['tvmedia']; ?>" href="javascript:void(0);">
                                       <?php echo $item['tvtitle']; ?>
                                    </a>
                                 </li>
                              <?php } ?>
                           </ul>
                        </div>
                     </div>
                     
                     <!-- Orta Alan - Player -->
                     <div class="col-md-7">
                        <div class="player-container">
                           <div class="player-warning top">
                              <i class="fas fa-exclamation-circle"></i>
                              Yükleme ekranında kalıyorsanız sayfayı yenileyin.
                           </div>
                           <div id="yaramiye"></div>
                           <div class="player-banner">
                              <a href="<?=$playerBanner['link']?>" target="_blank" rel="nofollow noopener">
                                 <img src="<?=$playerBanner['image']?>" alt="<?=$playerBanner['alt']?>">
                              </a>
                           </div>
                           <script type="text/javascript">
                              var playerElement = document.getElementById("yaramiye");
                              var player = new Clappr.Player({
                                 source: "<?=$item['tvmedia'];?>",
                                 mimeType: 'application/x-mpegURL',
                                 width: '100%',
                                 height: '100%',
                                 autoPlay: false,
                                 poster: "<?=$playerPoster['image']?>",
                                 posterClass: "poster-icon",
                                 watermark: "<?=$watermarkImage?>",
                                 watermarkLink: "<?=$watermarkLink?>",
                                 position: 'bottom-right',
                                 mediacontrol: {seekbar: "#00FF00", buttons: "#FFFFFF"},
                                 mute: false,
                                 gaAccount: "<?=$gaCode?>",
                                 disableErrorScreen: false,
                                 plugins: [ChromecastPlugin, LevelSelector, ClapprAds],
                                 chromecast: {
                                    appId: "9DFB77C0",
                                    contentType: "video/m3u8",
                                    media: {
                                       type: ChromecastPlugin.None,
                                       title: "IPTV",
                                       subtitle: "IPTV Streaming Service"
                                    }
                                 },
                                 levelSelectorConfig: {
                                    title: 'Kalite',
                                    labels: {
                                       2: 'Yüksek', // 720p
                                       1: 'Orta',   // 480p
                                       0: 'Düşük'   // 360p
                                    },
                                    labelCallback: function(playbackLevel, customLabel) {
                                       return customLabel;
                                    }
                                 },
                                 ads: {
                                    preRoll: {
                                       src: '<?=$prerollAds?>',
                                       skip: true,
                                       timeout: <?=$prerollTime?>,
                                       link: '<?=$prerollLink?>'
                                    },
                                    text: {
                                       wait: 'Wait % seconds...',
                                       skip: 'Skip >>>'
                                    }
                                 },
                                 disableVideoTagContextMenu: true,
                                 playbackNotSupportedMessage: 'Video oynatılamıyor. Lütfen tarayıcınızı kontrol edin.',
                                 autoPlayRetry: true,
                                 maxBufferLength: 30,
                                 maxBackBufferLength: 30,
                                 hlsjsConfig: {
                                    enableWorker: true,
                                    lowLatencyMode: true,
                                    backBufferLength: 90,
                                    liveSyncDurationCount: 3,
                                    liveMaxLatencyDurationCount: 10,
                                    maxBufferSize: 60 * 1000 * 1000,
                                    maxBufferLength: 30,
                                    fragLoadingTimeOut: 20000,
                                    manifestLoadingTimeOut: 20000,
                                    levelLoadingTimeOut: 20000,
                                    fragLoadingMaxRetry: 6,
                                    manifestLoadingMaxRetry: 6,
                                    levelLoadingMaxRetry: 6,
                                    fragLoadingMaxRetryTimeout: 5000,
                                    manifestLoadingMaxRetryTimeout: 5000,
                                    levelLoadingMaxRetryTimeout: 5000
                                 }
                              });

                              player.attachTo(playerElement);

                              // Hata yönetimi
                              player.on(Clappr.Events.PLAYER_ERROR, function(error) {
                                 console.error('Player Error:', error);
                                 setTimeout(function() {
                                    player.configure({
                                       source: player.options.source,
                                       autoPlay: true
                                    });
                                 }, 5000);
                              });

                              // Bağlantı kopması durumunda
                              player.on(Clappr.Events.PLAYBACK_ERROR, function(error) {
                                 console.error('Playback Error:', error);
                                 setTimeout(function() {
                                    player.configure({
                                       source: player.options.source,
                                       autoPlay: true
                                    });
                                 }, 5000);
                              });

                              // Player durumu değiştiğinde
                              player.on(Clappr.Events.PLAYER_STATE_CHANGED, function(state) {
                                 console.log('Player State:', state);
                              });
                           </script>
                        </div>
                     </div>
                     
                     <!-- Sağ Sidebar - Bahis Siteleri -->
                     <div class="col-md-3">
                        <div class="bahis-siteleri">
                           <h3 class="baslik">GÜVENİLİR BAHİS SİTELERİ</h3>
                           <?php foreach($bahisSiteleri as $site): ?>
                              <div class="bahis-item">
                                 <img src="<?=$site['logo']?>" alt="<?=$site['name']?>">
                                 <span class="site-name"><?=$site['name']?></span>
                                 <a href="<?=$site['link']?>" class="btn btn-danger btn-sm" target="_blank" rel="nofollow noopener">Kayıt Ol</a>
                              </div>
                           <?php endforeach; ?>
                        </div>
                     </div>
                  </div>
               </div>

               <!-- Alt banner'lar -->
               <div class="banner-container bottom-banners">
                  <div class="row">
                     <?php foreach($banners['bottom'] as $banner): ?>
                        <div class="col-md-4 col-sm-12">
                           <div class="reklam-banner">
                              <a href="<?=$banner['link']?>" target="_blank" rel="nofollow noopener">
                                 <img src="<?=$banner['image']?>" alt="<?=$banner['alt']?>">
                              </a>
                           </div>
                        </div>
                     <?php endforeach; ?>
                  </div>
               </div>

               <!-- SEO Metni -->
               <div class="seo-section">
                  <h2>Canlı Maç İzle - HD Kalitede Kesintisiz Maç Yayınları</h2>
                  
                  <p>Bonus Stream, futbolseverlere ücretsiz ve kesintisiz canlı maç izleme deneyimi sunan öncü bir platformdur. Bein Sports, Taraftarium24 ve Justin TV alternatifi olarak hizmet veren sitemizde, Süper Lig maçları, Şampiyonlar Ligi, UEFA Avrupa Ligi, Premier Lig, La Liga, Serie A ve Bundesliga dahil olmak üzere dünyanın önde gelen tüm futbol liglerini HD kalitede izleyebilirsiniz.</p>
                  
                  <p>Canlı maç yayınları konusunda uzmanlaşmış platformumuz, kullanıcılarına şifresiz maç izleme imkanı sunmaktadır. Mobil uyumlu tasarımımız sayesinde, dilediğiniz her yerden tablet ve telefonunuzla maçları takip edebilirsiniz. Donmayan yayın kalitemiz ve alternatif kanal seçeneklerimizle, futbol keyfinizi kesintisiz yaşamanızı sağlıyoruz.</p>
                  
                  <p>Bedava maç izle özelliğimizle birlikte, canlı skor takibi yapabilir, maç özetlerini izleyebilir ve güncel futbol haberlerine ulaşabilirsiniz. Taraftarium24 tv, Justin TV canlı maç ve Bein Sports izle seçeneklerimizle, aradığınız tüm spor içeriklerine tek bir adresten erişebilirsiniz. Selçuksports ve Jestyayın alternatifleri arasında en kaliteli yayın deneyimini sunan sitemiz, 7/24 kesintisiz hizmet vermektedir.</p>
                  
                  <h3>Neden Bonus Stream?</h3>
                  <div class="features">
                     <div class="feature-item">
                        <i class="fas fa-check"></i>
                        <span>HD kalitede canlı maç yayınları</span>
                     </div>
                     <div class="feature-item">
                        <i class="fas fa-check"></i>
                        <span>Şifresiz ve ücretsiz izleme imkanı</span>
                     </div>
                     <div class="feature-item">
                        <i class="fas fa-check"></i>
                        <span>Donmayan yayın teknolojisi</span>
                     </div>
                     <div class="feature-item">
                        <i class="fas fa-check"></i>
                        <span>Mobil uyumlu tasarım</span>
                     </div>
                     <div class="feature-item">
                        <i class="fas fa-check"></i>
                        <span>7/24 kesintisiz hizmet</span>
                     </div>
                     <div class="feature-item">
                        <i class="fas fa-check"></i>
                        <span>Alternatif kanal seçenekleri</span>
                     </div>
                     <div class="feature-item">
                        <i class="fas fa-check"></i>
                        <span>Kullanıcı dostu arayüz</span>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>

      <footer class="site-footer">
         <div class="container-fluid">
            <p class="copyright">
               © <?php echo date('Y'); ?> Bonus Stream - Tüm hakları saklıdır. | Tasarım & Geliştirme: <a href="https://arenasports.com" target="_blank" rel="nofollow noopener">Arena Sports</a>
            </p>
         </div>
      </footer>

      <!-- Bootstrap core JavaScript-->
      <script src="vendor/jquery/jquery.min.js"></script>
      <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
      <!-- Core plugin JavaScript-->
      <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
      <!-- Owl Carousel -->
      <script src="vendor/owl-carousel/owl.carousel.js"></script>
      <script src="js/list.min.js"></script>

      <!-- Mobil Menü JavaScript -->
      <script>
      document.addEventListener('DOMContentLoaded', function() {
          const menuToggle = document.querySelector('.menu-toggle');
          const mobileMenu = document.querySelector('.mobile-menu');
          const closeMenu = document.querySelector('.close-menu');

          // Menü toggle
          menuToggle.addEventListener('click', function(e) {
              e.stopPropagation();
              mobileMenu.classList.toggle('show');
          });

          // Kapatma butonu
          closeMenu.addEventListener('click', function() {
              mobileMenu.classList.remove('show');
          });

          // Dışarı tıklama
          document.addEventListener('click', function(e) {
              if (!mobileMenu.contains(e.target) && !menuToggle.contains(e.target)) {
                  mobileMenu.classList.remove('show');
              }
          });

          // Menü öğelerine tıklama
          const menuItems = document.querySelectorAll('.mobile-menu a');
          menuItems.forEach(item => {
              item.addEventListener('click', function() {
                  mobileMenu.classList.remove('show');
              });
          });
      });
      </script>

      <!-- Custom scripts for all pages-->
      <script src="js/main.js"></script>
      <script src="js/channels.js"></script>

      <script>
      // Player başlatma fonksiyonu
      function initPlayer(source) {
          try {
              if (typeof player !== 'undefined') {
                  player.destroy();
              }
              
              // Kaynak kontrolü
              if (!source) {
                  console.error("Geçersiz kaynak adresi");
                  return;
              }

              // İlk olarak HTTPS ile deneyelim
              let httpsSource = source;
              if (source.startsWith('http://')) {
                  httpsSource = source.replace('http://', 'https://');
              }
              
              var playerConfig = {
                  source: httpsSource,
                  parentId: "#player",
                  width: '100%',
                  height: '100%',
                  autoPlay: false,
                  mute: true,
                  poster: "<?=$playerPoster['image']?>",
                  plugins: [ChromecastPlugin, LevelSelector, ClapprAds],
                  chromecast: {
                      appId: '9DFB77C0'
                  },
                  levelSelectorConfig: {
                      title: 'Kalite',
                      labels: {
                          2: 'Yüksek',
                          1: 'Orta',
                          0: 'Düşük'
                      }
                  },
                  hlsjsConfig: {
                      enableWorker: true,
                      lowLatencyMode: true,
                      liveSyncDurationCount: 3,
                      liveMaxLatencyDurationCount: 10,
                      maxBufferLength: 30,
                      maxMaxBufferLength: 600,
                      backBufferLength: 90,
                      debug: false,
                      xhrSetup: function(xhr) {
                          xhr.withCredentials = false;
                      }
                  },
                  playback: {
                      crossOrigin: 'anonymous',
                      playInline: true,
                      mediaDataSource: {
                          withCredentials: false
                      }
                  }
              };

              player = new Clappr.Player(playerConfig);

              // Hata yönetimi
              player.on(Clappr.Events.PLAYER_ERROR, function(error) {
                  console.error("Player hatası:", error);
                  
                  // HTTPS başarısız olursa HTTP deneyelim
                  if (error.raw && error.raw.type === "networkError") {
                      let httpSource = httpsSource.replace('https://', 'http://');
                      console.log("HTTP kaynağı deneniyor:", httpSource);
                      
                      // Loading göster
                      document.getElementById('player').innerHTML = `
                          <div class="player-loading">
                              <div class="spinner"></div>
                              <p>Alternatif kaynak deneniyor...</p>
                          </div>
                      `;
                      
                      setTimeout(function() {
                          try {
                              player.configure({source: httpSource});
                              player.play();
                          } catch (e) {
                              console.error("HTTP kaynağı yükleme hatası:", e);
                              document.getElementById('player').innerHTML = `
                                  <div class="player-error">
                                      <i class="fas fa-exclamation-circle"></i>
                                      <p>Yayın yüklenemedi. Lütfen alternatif kanalları deneyiniz.</p>
                                  </div>
                              `;
                          }
                      }, 1000);
                  } else {
                      document.getElementById('player').innerHTML = `
                          <div class="player-error">
                              <i class="fas fa-exclamation-circle"></i>
                              <p>Yayın yüklenirken bir hata oluştu. Lütfen alternatif kanalları deneyiniz.</p>
                          </div>
                      `;
                  }
              });

              // Başarılı yükleme
              player.on(Clappr.Events.PLAYER_PLAY, function() {
                  console.log("Player başarıyla başlatıldı");
              });

          } catch (e) {
              console.error("Player başlatma hatası:", e);
              document.getElementById('player').innerHTML = `
                  <div class="player-error">
                      <i class="fas fa-exclamation-circle"></i>
                      <p>Yayın başlatılırken bir hata oluştu. Lütfen sayfayı yenileyiniz.</p>
                  </div>
              `;
          }
      }

      // Kanal değiştirme fonksiyonu
      $(document).ready(function() {
          $(".channel").click(function(e){
              e.preventDefault();
              try {
                  let channel = $(this).data("value");
                  if (channel) {
                      // Loading göster
                      document.getElementById('player').innerHTML = `
                          <div class="player-loading">
                              <div class="spinner"></div>
                              <p>Yayın yükleniyor...</p>
                          </div>
                      `;
                      
                      setTimeout(function() {
                          initPlayer(channel);
                      }, 1000);
                  }
              } catch (e) {
                  console.error("Kanal değiştirme hatası:", e);
              }
          });
      });
      </script>
   </body>
</html>
